% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_to_grid.R
\name{map_to_grid}
\alias{map_to_grid}
\title{Subset a map to positions on a grid}
\usage{
map_to_grid(map, grid)
}
\arguments{
\item{map}{A list of vectors of marker positions.}

\item{grid}{A list of logical vectors (aligned with
\code{map}), with TRUE indicating the position is on the grid.}
}
\value{
Same list as input, but subset to just include
pseudomarkers along a grid.
}
\description{
Subset a map object to the locations on some grid.
}
\details{
This is generally for the case of a map created with
\code{\link[=insert_pseudomarkers]{insert_pseudomarkers()}} with \code{step}>0 and
\code{stepwidth="fixed"}, so that the pseudomarkers form a grid
along each chromosome.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map_w_pmar <- insert_pseudomarkers(grav2$gmap, step=1)
sapply(map_w_pmar, length)
grid <- calc_grid(grav2$gmap, step=1)
map_sub <- map_to_grid(map_w_pmar, grid)
sapply(map_sub, length)
}
\seealso{
\code{\link[=calc_grid]{calc_grid()}}, \code{\link[=probs_to_grid]{probs_to_grid()}}
}
\keyword{utilities}
