% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_geno.R
\name{compare_geno}
\alias{compare_geno}
\title{Compare individuals' genotype data}
\usage{
compare_geno(cross, omit_x = FALSE, proportion = TRUE, quiet = TRUE, cores = 1)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{omit_x}{If TRUE, only use autosomal genotypes}

\item{proportion}{If TRUE (the default), the upper triangle of the
result contains the proportions of matching genotypes. If
FALSE, the upper triangle contains counts of matching
genotypes.}

\item{quiet}{IF \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A square matrix; diagonal is number of observed genotypes
for each individual. The values in the lower triangle are the
numbers of markers where both of a pair were genotyped. The
values in the upper triangle are either proportions or counts
of matching genotypes for each pair (depending on whether
\code{proportion=TRUE} or \verb{=FALSE}). The object is given
class \code{"compare_geno"}.
}
\description{
Count the number of matching genotypes between all pairs of
individuals, to look for unusually closely related individuals.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
cg <- compare_geno(grav2)
summary(cg)
}
\keyword{utilities}
