% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.R
\name{run_remote}
\alias{run_remote}
\title{\code{run_remote} - Runs the command locally or remotely using ssh.}
\usage{
run_remote(command, remote = FALSE, args = character(), verbose = FALSE,
  shell = FALSE)
}
\arguments{
\item{command}{Command to run. If run locally, quotes should be escaped once.
If run remotely, quotes should be escaped twice.}

\item{remote}{Remote machine specification for ssh, in format such as \code{user@server} that does not
require interactive password entry. For local execution, pass \code{FALSE} (default). For
execution on the default qsub config remote, use \code{TRUE}.}

\item{args}{Character vector, arguments to the command.}

\item{verbose}{If \code{TRUE} prints the command.}

\item{shell}{Whether to execute the command in a shell}
}
\value{
A list with components:
\itemize{
\item \code{status} The exit status of the process. If this is NA, then the process was killed and had no exit status.
\item \code{stdout} The standard output of the command, in a character scalar.
\item \code{stderr} The standard error of the command, in a character scalar.
\item \code{elapsed_time} The number of seconds required before this function returned an output.
}
Warnings are really errors here so the error flag is set if there are warnings.
}
\description{
In \code{run_remote} the remote commands are enclosed in wrappers that allow to capture output.
By default stderr is redirected to stdout.
If there's a genuine error, e.g., the remote command does not exist, the output is not captured. In this case, one can
see the output by setting \code{intern} to \code{FALSE}. However, when the command is run but exits with non-zero code,
\code{run_remote} intercepts the generated warning and saves the output.
}
\details{
The remote command will be put inside double quotes twice, so all quotes in cmd must be escaped twice: \code{\\\"}.
However, if the command is not remote, i.e., \code{remote} is \code{NULL} or empty string, quotes should be escaped
only once.

If the command itself redirects output, the \code{stderr_redirect} flag should be set to \code{FALSE}.
}
