% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-helpers.R
\name{is_tag_line}
\alias{is_tag_line}
\title{Detect the presence of a properly structured tagline}
\usage{
is_tag_line(line)
}
\arguments{
\item{line}{A character vector to check. It is a vectorized function.}
}
\value{
Logical. Indicating whether each line matches tag specification.
}
\description{
Checks whether a specially structured comment line if formatted in the way that
qryflow expects.
}
\details{
Tag lines should look like this: \verb{-- @key: value}
\itemize{
\item Begins with an inline comment (\verb{--})
\item An \code{@} precedes a tag type (e.g., \code{type}, \code{name}, \code{query}, \code{exec}) and is followed by a colon (\code{:})
\item A value is provided
}
}
\examples{
a <- "-- @query: df_mtcars"
b <- "-- @exec: prep_tbl"
c <- "-- @type: query"

lines <- c(a, b, c)

is_tag_line(lines)
}
