% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{makemermaid}
\alias{makemermaid}
\title{makemermaid}
\usage{
makemermaid(.object., ..., file)
}
\arguments{
\item{.object.}{character string or vector with \code{mermaid} markup}

\item{...}{name=value pairs that makes values replace \code{{{name}}} elements in the markup}

\item{file}{name of file to hold \code{mermaid} markup after variable insertions.  Run this in Quarto using a chunk to looks like the following, which was for \code{file='mermaid1.mer'}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{mermaid\}
\%\%| fig-cap: "Consort diagram produced by `mermaid`"
\%\%| label: fig-mermaid1
\%\%| file: mermaid1.mer
```
}\if{html}{\out{</div>}}}
}
\value{
nothing; used to \code{knitr::knit_expand()} mermaid markup
}
\description{
Create a Quarto Mermaid Diagram Chunk With Variable Insertions
}
\details{
Takes a character string or vector and uses \code{\link[knitr:knit_expand]{knitr::knit_expand()}} to apply variable insertions before the diagram is rendered by Quarto.  See \href{https://hbiostat.org/rflow/doverview.html#fig-mermaid1/}{this} for an example.
}
\seealso{
\code{\link[=makegraphviz]{makegraphviz()}}
}
\author{
Frank Harrell
}
