% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_bayes.R
\name{gmap}
\alias{gmap}
\title{Finemapping using Bayesian Linear Regression Models}
\usage{
gmap(
  Glist = NULL,
  stat = NULL,
  sets = NULL,
  models = NULL,
  rsids = NULL,
  ids = NULL,
  mask = NULL,
  lambda = NULL,
  vb = NULL,
  vg = NULL,
  ve = NULL,
  vy = NULL,
  pi = NULL,
  gamma = NULL,
  mc = 5000,
  h2 = 0.5,
  nub = 4,
  nug = 4,
  nue = 4,
  ssb_prior = NULL,
  ssg_prior = NULL,
  sse_prior = NULL,
  vb_prior = NULL,
  vg_prior = NULL,
  ve_prior = NULL,
  updateB = TRUE,
  updateG = TRUE,
  updateE = TRUE,
  updatePi = TRUE,
  formatLD = "dense",
  checkLD = FALSE,
  shrinkLD = FALSE,
  shrinkCor = FALSE,
  pruneLD = FALSE,
  checkConvergence = FALSE,
  critVe = 3,
  critVg = 3,
  critVb = 3,
  critPi = 3,
  critB = 3,
  critB1 = 0.5,
  critB2 = 3,
  verbose = FALSE,
  eigen_threshold = 0.995,
  cs_threshold = 0.9,
  cs_r2 = 0.5,
  nit = 1000,
  nburn = 100,
  nthin = 1,
  output = "summary",
  method = "bayesR",
  algorithm = "mcmc-eigen",
  seed = 10
)
}
\arguments{
\item{Glist}{A list containing information on genotypic data, including SNPs, chromosomes, positions, and optionally, LD matrices.}

\item{stat}{A data frame or list of summary statistics including effect sizes, standard errors, sample sizes, etc.}

\item{sets}{Optional list specifying sets of SNPs for mapping.}

\item{models}{Optional list of predefined models for Bayesian regression.}

\item{rsids}{Vector of SNP identifiers.}

\item{ids}{Vector of sample identifiers.}

\item{mask}{Logical matrix indicating SNPs to exclude from analysis.}

\item{lambda}{Vector of initial values for penalty parameters in the model.}

\item{vb}{Initial value for the marker effect variance (default: NULL).}

\item{vg}{Initial value for the genetic variance (default: NULL).}

\item{ve}{Initial value for the residual variance (default: NULL).}

\item{vy}{Initial value for the phenotypic variance (default: NULL).}

\item{pi}{Vector of initial values for pi parameters in the model (default of pi=c(0.999,0.001) for bayesC and pi=c(0.994,0.003,0.002,0.001).}

\item{gamma}{Vector of initial values for gamma parameters in the model (default of gamma=c(0,1) for bayesC and gamma=c(0,0.01,0.1,1).}

\item{mc}{Number of potentiel genome-wide causal markers for the trait analysed - only used for specification of ssb_prior (default: 5000).}

\item{h2}{Heritability estimate (default: 0.5).}

\item{nub, nug, nue}{Degrees of freedom parameters for the priors of marker, genetic, and residual variances, respectively.}

\item{ssb_prior, ssg_prior, sse_prior}{Priors for the marker, genetic, and residual variances.}

\item{vb_prior, vg_prior, ve_prior}{Additional priors for marker, genetic, and residual variances (default: NULL).}

\item{updateB, updateG, updateE, updatePi}{Logical values specifying whether to update marker effects, genetic variance, residual variance, and inclusion probabilities, respectively.}

\item{formatLD}{Format of LD matrix ("dense" by default).}

\item{checkLD}{Logical, whether to check the LD matrix for inconsistencies (default: FALSE).}

\item{shrinkLD, shrinkCor}{Logical, whether to apply shrinkage to the LD or correlation matrices (default: FALSE).}

\item{pruneLD}{Logical, whether to prune LD matrix (default: FALSE).}

\item{checkConvergence}{Logical, whether to check for convergence of the Gibbs sampler (default: FALSE).}

\item{critVe, critVg, critVb, critPi, critB, critB1, critB2}{Convergence criteria for residual, genetic, and marker variances, inclusion probabilities, and marker effects.}

\item{verbose}{Logical, whether to print detailed output for debugging (default: FALSE).}

\item{eigen_threshold}{Threshold for eigenvalues in eigen decomposition (default: 0.995).}

\item{cs_threshold, cs_r2}{PIP and r2 thresholds credible set construction (default: cs_threshold=0.9, cs_r2=0.5)}

\item{nit}{Number of iterations in the MCMC sampler (default: 5000).}

\item{nburn}{Number of burn-in iterations (default: 500).}

\item{nthin}{Thinning interval for MCMC (default: 5).}

\item{output}{Level of output, options include "summary", "full".}

\item{method}{The regression method to use, options include "blup", "bayesN", "bayesA", "bayesL", "bayesC", "bayesR".}

\item{algorithm}{Algorithm for MCMC sampling, options include "mcmc", "em-mcmc", "mcmc-eigen".}

\item{seed}{Random seed for reproducibility (default: 10).}
}
\value{
Returns a list structure including the following components:
}
\description{
In the Bayesian multiple regression model, the posterior density of the model parameters depends
on the likelihood of the data given the parameters and a prior probability for the model parameters.
The choice of the prior for marker effects can influence the type and extent of shrinkage induced in the model.
}
\details{
This function implements Bayesian linear regression models to provide unified mapping of 
genetic variants, estimate genetic parameters (e.g. heritability), and predict disease risk.
It is designed to handle various genetic architectures and scale efficiently with large datasets.
}
\author{
Peter Sørensen
}
