% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{qdft2qacf}
\alias{qdft2qacf}
\title{Quantile Autocovariance Function (QACF)}
\usage{
qdft2qacf(y.qdft, return.qser = FALSE)
}
\arguments{
\item{y.qdft}{matrix or array of QDFT from \code{qdft()}}

\item{return.qser}{if \code{TRUE}, return quantile series (QSER) along with QACF}
}
\value{
matrix or array of quantile autocovariance function if \code{return.sqer = FALSE} (default), else a list with the following elements:
  \item{qacf}{matirx or array of quantile autocovariance function}
  \item{qser}{matrix or array of quantile series}
}
\description{
This function computes quantile autocovariance function (QACF) from QDFT.
}
\examples{
# single time series
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.qdft <- qdft(y1,tau)
y.qacf <- qdft2qacf(y.qdft)
plot(c(0:9),y.qacf[c(1:10),1],type='h',xlab="LAG",ylab="QACF")
y.qser <- qdft2qacf(y.qdft,return.qser=TRUE)$qser
plot(y.qser[,1],type='l',xlab="TIME",ylab="QSER")
# multiple time series
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
y.qdft <- qdft(cbind(y1,y2),tau)
y.qacf <- qdft2qacf(y.qdft)
plot(c(0:9),y.qacf[1,2,c(1:10),1],type='h',xlab="LAG",ylab="QACF")
}
