% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_terms.R
\name{freq_terms}
\alias{freq_terms}
\title{Find Frequent Terms}
\usage{
freq_terms(text.var, top = 20, at.least = 1, stopwords = NULL,
  extend = TRUE, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{top}{Top number of terms to show.}

\item{at.least}{An integer indicating at least how many letters a word 
must be to be included in the output.}

\item{stopwords}{A character vector of words to remove from the text.  qdap 
has a number of data sets that can be used as stop words including: 
\code{Top200Words}, \code{Top100Words}, \code{Top25Words}.  For the tm 
package's traditional English stop words use \code{tm::stopwords("english")}.}

\item{extend}{logical.  If \code{TRUE} the \code{top} argument is extended to 
any word that has the same frequency as the \code{top} word.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{all_words}}.}
}
\value{
Returns a dataframe with the top occurring words.
}
\description{
Find the most frequently occurring terms in a text vector.
}
\examples{
\dontrun{
freq_terms(DATA$state, 5)
freq_terms(DATA$state)
freq_terms(DATA$state, extend = FALSE)
freq_terms(DATA$state, at.least = 4)
(out <- freq_terms(pres_debates2012$dialogue, stopwords = Top200Words))
plot(out)

## All words by sentence (row)
library(qdapTools)
x <- raj$dialogue
list_df2df(setNames(lapply(x, freq_terms, top=Inf), seq_along(x)), "row")
list_df2df(setNames(lapply(x, freq_terms, top=10, stopwords = Dolch), 
    seq_along(x)), "Title")


## All words by person
FUN <- function(x, n=Inf) freq_terms(paste(x, collapse=" "), top=n)
list_df2df(lapply(split(x, raj$person), FUN), "person")

## Plot it
out <- lapply(split(x, raj$person), FUN, n=10)
pdf("Freq Terms by Person.pdf", width=13) 
lapply(seq_along(out), function(i) {
    ## dev.new()
    plot(out[[i]], plot=FALSE) + ggtitle(names(out)[i])
})
dev.off()

## Keep spaces
freq_terms(space_fill(DATA$state, "are you"), 500, char.keep="~~")
}
}
\seealso{
\code{\link[qdap]{word_list}},
\code{\link[qdap]{all_words}}
}
\keyword{frequent_terms}
