% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/end_mark.R
\name{end_mark}
\alias{end_mark}
\alias{end_mark_by}
\title{Sentence End Marks}
\usage{
end_mark(text.var, missing.end.mark = "_", missing.text = NA,
  other.endmarks = NULL)

end_mark_by(text.var, grouping.var, digits = 3, percent = FALSE,
  zero.replace = 0, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{missing.end.mark}{A value to use for sentences with missing endmarks.}

\item{missing.text}{A value to use for sentences with missing (\code{NA}) 
text.}

\item{other.endmarks}{Other 1-2 character endmarks to search for.}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates 
one word list for all text.  Also takes a single grouping variable or a list 
of 1 or more grouping variables.}

\item{digits}{Integer; number of decimal places to round when printing.}

\item{percent}{logical.  If \code{TRUE} output given as percent.  If 
\code{FALSE} the output is proportion.}

\item{zero.replace}{Value to replace 0 values with.}

\item{\ldots}{Other arguments passed to \code{end_mark}.}
}
\value{
Returns a character vector of qdap end marks for each sentence.  
End marks include:
\item{"."}{Declarative sentence.} 
\item{"?"}{Question sentence.} 
\item{"!"}{Exclamatory sentence.} 
\item{"|"}{Incomplete sentence.} 
\item{"*."}{Imperative-declarative sentence.} 
\item{"*?"}{Imperative-question sentence (unlikely to occur)} 
\item{"*!"}{Imperative-exclamatory sentence.} 
\item{"*|"}{Imperative-incomplete sentence.} 
\item{"no.em"}{No end mark.}
\item{"blank"}{Empty cell/NA.}
}
\description{
\code{end_mark} - Grab the sentence end marks for a transcript.  This can be 
useful to categorize based on sentence type.

\code{end_mark_by} - Grab the sentence end marks for a transcript by grouping 
variable(s).
}
\examples{
\dontrun{
end_mark(DATA.SPLIT$state)
end_mark(mraja1spl$dialogue)
table(end_mark(mraja1spl$dialogue))
plot(end_mark(mraja1spl$dialogue))
ques <- mraja1spl[end_mark(mraja1spl$dialogue) == "?", ] #grab questions
htruncdf(ques)
non.ques <- mraja1spl[end_mark(mraja1spl$dialogue) != "?", ] #non questions
htruncdf(non.ques, 20)
ques.per <- mraja1spl[end_mark(mraja1spl$dialogue) \%in\% c(".", "?"), ] #grab ? and .
htruncdf(ques.per, 20)

(x_by <- end_mark_by(DATA.SPLIT$state, DATA.SPLIT$person))
scores(x_by)
counts(x_by)
proportions(x_by)
preprocessed(x_by)
plot(scores(x_by))
plot(counts(x_by))
plot(proportions(x_by))
plot(preprocessed(x_by))

#================================#
## End Marks Over Time Examples ##
#================================#
##EXAMPLE 1
sentpres <- lapply(with(pres_debates2012, split(dialogue, time)), function(x) {
    end_mark(x)
})

sentplots <- lapply(seq_along(sentpres), function(i) {
    m <- plot(cumulative(sentpres[[i]]))
    if (i != 2) m <- m + ylab("")
    if (i != 3) m <- m + xlab(NULL)
    m + ggtitle(paste("Debate", i))
})

library(grid)
library(gridExtra)
do.call(grid.arrange, sentplots)

##EXAMPLE 2
sentraj <- lapply(with(rajSPLIT, split(dialogue, act)), function(x) {
    end_mark(x)
})
 
sentplots2 <- lapply(seq_along(sentraj), function(i) {
    m <- plot(cumulative(sentraj[[i]]))
    if (i != 2) m <- m + ylab("")
    if (i != 3) m <- m + xlab(NULL)
    act <- qcv(I, II, III, IV, V)
    m + ggtitle(paste("Act", act[i]))
})

## ggplot2 function to extract legend
g_legend <- function(a.gplot){ 
    tmp <- ggplot_gtable(ggplot_build(a.gplot)) 
    leg <- which(sapply(tmp[["grobs"]], function(x) x[["name"]]) == "guide-box") 
    legend <- tmp[["grobs"]][[leg]] 
    legend
} 

## remove legends from plots
sentplots3 <- lapply(sentplots2, function(x){
    x + theme(legend.position="none") + xlab(NULL) + ylab(NULL)
})

sentplots3[[6]] <- g_legend(sentplots2[[1]]) 

do.call(grid.arrange, sentplots3)
}
}
\keyword{end-mark}
