% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexical_classification.R
\name{plot.lexical_classification}
\alias{plot.lexical_classification}
\title{Plots a lexical_classification Object}
\usage{
\method{plot}{lexical_classification}(x, bar.size = 5, low = "blue",
  mid = "grey99", high = "red", ave.lexical_classification.shape = "+",
  alpha = 1/4, shape = 19, point.size = 2.5, jitter = 0.1,
  nrow = NULL, na.rm = TRUE, order.by.lexical_classification = TRUE,
  plot = TRUE, error.bars = TRUE, error.bar.height = 0.5,
  error.bar.size = 0.5, error.bar.color = "black", error.bar.alpha = 0.6,
  ...)
}
\arguments{
\item{x}{The lexical_classification object.}

\item{bar.size}{The size of the bars used in the Gantt plot.}

\item{low}{The color to be used for lower values.}

\item{mid}{The color to be used for mid-range values (default is a less 
striking color).}

\item{high}{The color to be used for higher values.}

\item{ave.lexical_classification.shape}{The shape of the average lexical_classification score used in the 
dot plot.}

\item{alpha}{Transparency level of points (ranges between 0 and 1).}

\item{shape}{The shape of the points used in the dot plot.}

\item{point.size}{The size of the points used in the dot plot.}

\item{jitter}{Amount of vertical jitter to add to the points.}

\item{nrow}{The number of rows in the dotplot legend (used when the number of 
grouping variables makes the legend too wide).  If \code{NULL} no legend if 
plotted.}

\item{na.rm}{logical. Should missing values be removed?}

\item{order.by.lexical_classification}{logical.  If \code{TRUE} the group lexical_classification plot 
will be ordered by average lexical_classification score, otherwise alphabetical order is 
assumed.}

\item{plot}{logical.  If \code{TRUE} the plot will automatically plot.
The user may wish to set to \code{FALSE} for use in knitr, sweave, etc.
to add additional plot layers.}

\item{error.bars}{logical.  If \code{TRUE} error bars are added to the 
lexical_classification dot plot using the standard error of the mean lexical_classification score.}

\item{error.bar.height}{The height of the error bar ends.}

\item{error.bar.size}{The size/thickness of the error bars.}

\item{error.bar.color}{The color of the error bars.  If \code{NULL} each 
bar will be colored by grouping variable.}

\item{error.bar.alpha}{The alpha level of the error bars.}

\item{\ldots}{ignored}
}
\value{
Invisibly returns the \code{ggplot2} objects that form the larger 
plot.
}
\description{
Plots a lexical_classification object as a heat map Gantt plot with lexical_classification over 
time (measured in words) and lexical_classification scores per sentence.  In the dotplot 
plot the black dots are the average lexical_classification per grouping variable.
}
