% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarity.R
\name{Animate.polarity}
\alias{Animate.polarity}
\title{Animate Polarity}
\usage{
\method{Animate}{polarity}(x, negative = "blue", positive = "red",
  neutral = "yellow", edge.constant, wc.time = TRUE, time.constant = 2,
  title = NULL, digits = 3, width = 65, current.color = "black",
  current.speaker.color = NULL, non.speaker.color = NA,
  ave.color.line = "red", type = "network", coord = c(0, 0.5),
  just = c(0, 0.5), ...)
}
\arguments{
\item{x}{A \code{\link[qdap]{polarity}} object.}

\item{negative}{The color to use for negative polarity.}

\item{positive}{The color to use for positive polarity.}

\item{neutral}{The color to use for neutral polarity.}

\item{edge.constant}{A constant to multiple edge width by.}

\item{wc.time}{logical.  If \code{TRUE} weights duration of frame by word 
count.}

\item{time.constant}{A constant to divide the maximum word count by.  Time
is calculated by `round(exp(WORD COUNT/(max(WORD COUNT)/time.constant)))`.  
Therefore a larger constant will make the difference between the large and 
small word counts greater.}

\item{title}{The title to apply to the animated image(s).}

\item{digits}{The number of digits to use in the current turn of talk 
polarity.}

\item{width}{The width to break text at if \code{type = "text"}.}

\item{current.color}{The color to use for the current turn of talk polarity.}

\item{current.speaker.color}{The color for the current speaker.}

\item{non.speaker.color}{The color for the speakers not currently speaking.}

\item{ave.color.line}{The color to use for the average color line if 
\code{type = "network"}.}

\item{type}{Character string of either \code{"network"} (as a network 
plot), \code{"bar"} (as a bar plot), or \code{"text"} (as a simple 
colored text plot).}

\item{coord}{The x/y coordinate to plot the test if \code{type = "text"}.}

\item{just}{The \code{hjust} and \code{vjust} values to use for the text if 
\code{type = "text"}.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{discourse_map}} or
\code{\link[ggplot2]{annotate}} if \code{type = "text"}.}
}
\description{
\code{Animate.polarity} - Animate a \code{\link[qdap]{polarity}} object.
}
\details{
polarity Method for Animate
}
\note{
The width of edges is based on words counts on that edge until that 
moment divided by total number of words used until that moment.  Thicker 
edges tend to thin as time passes.  The actual duration the current edge 
stays as the \code{current.color} is based on word counts for that particular 
flow of dialogue divided by total dialogue (words) used.  The edge label is
the current polarity for that turn of talk (an aggregation of the sub 
sentences of the current turn of talk).  The coloring of the current edge 
polarity is produced at th sentence level, therefor a label may indicate a 
positive current turn of talk, while the coloring may indicate a negative 
sentences.
}

