% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{qad_distribution}
\alias{qad_distribution}
\alias{pqad}
\alias{qqad}
\title{Distribution of qad (H0: independence)}
\usage{
pqad(q, n, R = 1000, resolution = NULL)

qqad(p, n, R = 1000, resolution = NULL)
}
\arguments{
\item{q}{vector of quantiles.}

\item{n}{number of observations (or minimum of unique values, if ties occur).}

\item{R}{number of repetitions (default R = 1000)}

\item{resolution}{resolution of checkerboard copula (default  = NULL)}

\item{p}{vector of probabilities.}
}
\value{
\code{pqad} gives the distribution function, i.e. P(qad <= q). \code{qqad} gives the quantile function.
The length of the result is determined by the length of q or p, respectively.
}
\description{
Distribution function - P_H0(qad <= q) - and quantile function for the qad distribution with regard
to the null hypthesis (H0) stating independence between X and Y.
}
\details{
The distribution of qad in the setting of independence, i.e., the random variables
X and Y are independent. The distribution is calculated in the following way: Samples of size n
are drawn from independent random variables. Then qad is calculated. The procedure is repeated R times. #'
}
\examples{
pqad(0.3, 45)
qqad(0.5, 30)
}
