% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.qad}
\alias{plot.qad}
\title{Plot conditional probabilites}
\usage{
\method{plot}{qad}(x, addSample = FALSE, copula = FALSE,
  density = FALSE, margins = FALSE, point.size = 0.8,
  panel.grid = TRUE, ...)
}
\arguments{
\item{x}{an object of class qad.}

\item{addSample}{a logical determining whether the observations (or pseudo-observations) are added in the plot (default = FALSE).}

\item{copula}{a logical indicating whether the plot depicts the conditional probabilities
of the empirical checkerboard copula or of the retransformed data setting (default = FALSE).}

\item{density}{a logical indicating whether the density should be plotted instead of the conditional probabilites (default = FALSE).
Only works in the copula setting, i.e. if copula = TRUE.}

\item{margins}{a logical indicating whether the margin distribution is added in form of a rug plot.}

\item{point.size}{a numeric specifying the point size of the sample (relevant if addSample = TRUE).}

\item{panel.grid}{a logical indicating whether the panel grid is plotted. (default = TRUE)}

\item{...}{some methods for this generic require additional arguments.  None are used in this method.}
}
\description{
Plots conditional probabilities for each strip of the checkerboard copula in the copula setting or in the retransformed data setting.
}
\note{
The conditional probabilities are constant at squares in the copula setting. If the squares are retransformed in the data setting, the resulting objects are rectangles.
}
\examples{
## Example 1
n <- 1000
x <- runif(n, 0, 1)
y <- runif(n, 0, 1)
sample <- data.frame(x, y)

#qad (Not Run)
# mod <- qad(sample)
# plot(mod, addSample = TRUE, copula = FALSE)

## Example 2
n <- 1000
x <- runif(n, -1, 1)
y <- x^2 + rnorm(n, 0, 0.1)
sample <- data.frame(x, y)

#qad (Not Run)
# mod <- qad(sample)
# plot(mod, addSample = TRUE, copula = TRUE)
# plot(mod, addSample = TRUE, copula = FALSE)

}
