% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_data.R
\name{px_data}
\alias{px_data}
\alias{px_data.px}
\title{DATA}
\usage{
px_data(x, value, validate)

\method{px_data}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A data frame. If missing, the current DATA is returned.
If NULL, all data rows are removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or data frame.
}
\description{
Inspect or change DATA.
}
\details{
If adding a new data frame, metadata is generated for the new
columns and removed for columns that are no longer present.
}
\examples{
x1 <- px(population_gl)

# Print data table
px_data(x1)

# Change data table
population_gl_2024 <- subset(population_gl, year == 2024)

x2 <- px_data(x1, population_gl_2024)

}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A32\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C502\%2C0\%5D}{Statistics Sweden's documentation}
}
