% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fit.pseu.model}
\alias{fit.pseu.model}
\title{Create an artificial model object}
\usage{
fit.pseu.model(formula, data, beta, VarCov, sigma, ...)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}}}

\item{data}{a data frame with the independent variables of the design as
columns, e.g., treatment factors and block factors.}

\item{beta}{a vector of the expectations of model coefficients.}

\item{VarCov}{variance-covariance matrices. If there are multiple random effect groups,
supply the variance-covariance matrix of each group as an element in a list.}

\item{sigma}{standard deviation of error}

\item{...}{other arguments passed to the \code{anova} function in \code{lmerTest}.
The type of sum of squares, with Type III as the default, and the method for
computing the denominator degrees of freedom, with Satterthwaite's method as the default, can be changed.
For more details, see \link[lmerTest]{anova.lmerModLmerTest}.}
}
\value{
a pseudo model object.
}
\description{
Create a pseudo-model object with the response variable being simulated
according to the fixed and random effects. Model coefficients are replaced
by the expectations specified in the argument \code{beta}. Variance-covariance
components of random effects are replaced by the values specified in argument
\code{VarCov}. The standard deviation of random error is replaced by the
argument \code{sigma}. Creating such a pseudo-model facilitates power
calculations by leveraging the \code{anova} function in \code{lmerTest} and
the \code{Anova} function in \code{car}.
}
