% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svarirf.R
\name{PP}
\alias{PP}
\alias{PP.system}
\alias{PP.variable}
\title{Persistence Profiles}
\usage{
PP.system(x, n.ahead = 20)

PP.variable(x, n.ahead = 20, shock = NULL)
}
\arguments{
\item{x}{Rank-restricted VAR object of class '\code{varx}' or any other 
that can be \link[=as.varx]{coerced} to '\code{varx}', e.g. '\code{\link[vars]{vec2var}}'. 
If the object is also of child class '\code{id}', \code{\link{PP.variable}} calculates 
the persistence profiles which are initiated by the provided structural shocks.}

\item{n.ahead}{Integer. Number of periods to consider after the initial impulse, i.e. the horizon of the PP.}

\item{shock}{Matrix. Each column vector specifies a set of simultaneous shocks, 
which initiate \eqn{r} persistence profiles. If \code{NULL} (the default),
a separate unit impulse is set for each shock.}
}
\value{
A list of class '\code{svarirf}' holding the persistence profiles as a '\code{data.frame}'.
}
\description{
Calculates persistence profiles for each of the \eqn{r} long-run relationships.
}
\section{Functions}{
\itemize{
\item \code{PP.system()}: PP due to a system-wide shock

\item \code{PP.variable()}: PP due to a structural or variable-specific shock

}}
\examples{
data("PCAP")
names_k = c("g", "k", "l", "y") # variable names
names_i = levels(PCAP$id_i)     # country names
L.data  = sapply(names_i, FUN=function(i) 
  ts(PCAP[PCAP$id_i==i, names_k], start=1960, end=2019, frequency=1), 
  simplify=FALSE)
  
# estimate VAR for DNK under rank-restriction r=2 #
dim_r  = 2  # cointegrataion rank
R.t_D1 = list(t_break=c(23, 49))  # trend breaks
R.vecm = VECM(y=L.data$DNK, dim_p=2, dim_r=dim_r, type="Case4", t_D1=R.t_D1)

# define shocks #
shock1 = diag(4)   # 4 separate shocks
shock2 = cbind(c(1, 0,  0, 0),  # positive shock on "g"
               c(0, 0, -1, 0),  # negative shock on "l"
               c(0, 0,  1, 1))  # simultaneous shocks

# calculate persistence profiles #
R.ppv1 = PP.variable(R.vecm, n.ahead=50, shock=shock1)
R.ppv2 = PP.variable(R.vecm, n.ahead=50, shock=shock2)
R.ppsy = PP.system(R.vecm, n.ahead=50)

# edit plots #
library("ggplot2")
as.pplot(ppv1=plot(R.ppv1), n.rows=4)$F.plot + guides(color="none")
as.pplot(ppv2=plot(R.ppv2), n.rows=3, color_g="black") # reshape facet array
plot(R.ppsy, selection=list(1, c(1,4)))  # dismiss cross-term PP

}
\references{
Lee, K., C., Pesaran, M. H. (1993): 
  "Persistence Profiles and Business Cycle Fluctuations in a Disaggregated Model of UK Output Growth", 
  \emph{Richerche Economiche}, 47, pp. 293-322.

Pesaran, M. H., and Shin, Y. (1996): 
  "Cointegration and Speed of Convergence to Equilibrium", 
  \emph{Journal of Econometrics}, 71, pp. 117-143.
}
