% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_bar.R
\name{progress_bar}
\alias{progress_bar}
\title{Create a R6 progress bar directly}
\usage{
progress_bar(total, title = "Progress", ...,
  type = getOption("progress.type", infer_type()))
}
\arguments{
\item{total}{the total number of elements}

\item{title}{the title of the progress bar}

\item{...}{passed on to the specific constructor determined by type.}

\item{type}{the type of progress bar to create as a string, or an
\code{R6ClassGenerator} object for a class that inherits from
the "R6 Progress Base Class".}
}
\description{
Create a R6 progress bar directly
}
\examples{

progress_bar(100, "Windows Progress", type = 'win')
progress_bar(100, "Text Progress", type = 'txt')

# The following use Unicode characters and may not work with all fonts.
# DejaVu Sans Mono is one font which supports all the characters used
progress_bar(100, "Bar Progress", type = 'bar')
progress_bar(100, "Line Progress", type = 'line')
progress_bar(100, "Box Progress", type = 'box')
progress_bar(100, "Block Progress", type = 'block')

}
