% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected.R
\encoding{UTF-8}
\name{exp_Fa}
\alias{exp_Fa}
\title{Expected ancestral inbreeding coefficient}
\usage{
exp_Fa(Ne, t)
}
\arguments{
\item{Ne}{Effective population size}

\item{t}{Generation number}
}
\value{
The ancestral inbreeding coefficient
}
\description{
Estimates the expected ancestral inbreeding coefficient (Fa) as a function of the effective population size and generation number
}
\details{
Computation of the ancestral inbreeding coefficient uses the adaptation from Ballou's (1997) formula, as in López-Cortegano et al. (2018):

Fa(t) = 1 - (1 - 1/2N) ^ (1/2 (t-1)t)
}
\examples{
exp_Fa(Ne = 50, t = 0)
exp_Fa(Ne = 50, t = 50)
exp_Fa(Ne = 10, t = 50)
}
\references{
\itemize{
  \item{Ballou JD. 1997. Ancestral inbreeding only minimally affects inbreeding depression in mammalian populations. J Hered. 88:169–178.}
  \item{López-Cortegano E et al. 2018. Detection of genetic purging and predictive value of purging parameters estimated in pedigreed populations. Heredity 121(1): 38-51.}
}
}
\seealso{
\code{\link{ip_Fa}}
}
