% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_pum_dynamic.R
\name{sample_pum_dynamic}
\alias{sample_pum_dynamic}
\title{Generate posterior samples from the dynamic probit unfolding model}
\usage{
sample_pum_dynamic(
  vote_info,
  years_v,
  hyperparams,
  control,
  sign_refs,
  verbose = FALSE,
  pre_run = NULL,
  appended = FALSE
)
}
\arguments{
\item{vote_info}{A logical vote matrix where rows represent members and columns represent issues.
The entries should be FALSE ("No"), TRUE ("Yes"), or NA (missing data).}

\item{years_v}{A vector representing the time period for each vote in the model.}

\item{hyperparams}{A list of hyperparameter values including:
- `beta_mean`: Prior mean of beta.
- `beta_var`: Prior variance of beta.
- `alpha_mean`: A vector of 2 values for the prior means of alpha1 and alpha2.
- `alpha_scale`: Scale parameter for alpha1 and alpha2.
- `delta_mean`: A vector of 2 values for the prior means of delta1 and delta2.
- `delta_scale`: Scale parameter for delta1 and delta2.
- `rho_mean`: Prior mean of the autocorrelation parameter `rho`.
- `rho_sigma`: Standard deviation of the prior for `rho`.}

\item{control}{A list specifying the MCMC configurations, including:
- `num_iter`: Total number of iterations.
- `burn_in`: The number of initial iterations to discard as part of the burn-in period before retaining samples.
- `keep_iter`: Interval at which samples are retained.
- `flip_rate`: Probability of directly flipping signs in the M-H step, rather than resampling from the priors.
- `sd_prop_rho`: Proposal standard deviation for `rho` in the Metropolis-Hastings step.}

\item{sign_refs}{A list containing sign constraints, including:
- `pos_inds`: Indices of members constrained to have positive values.
- `neg_inds`: Indices of members constrained to have negative values.
- `pos_year_inds`: List of years corresponding to each `pos_ind`.
- `neg_year_inds`: List of years corresponding to each `neg_ind`.}

\item{verbose}{Logical. If `TRUE`, prints progress and additional information during the sampling process.}

\item{pre_run}{A list containing the output from a previous run of the function. If provided, the last iteration of the previous run will be used as the initial point of the new run. Defaults to `NULL`.}

\item{appended}{Logical. If `TRUE`, the new samples will be appended to the samples from the previous run. Defaults to `FALSE`.}
}
\value{
A list containing:
  - `beta`: A data frame of posterior samples for beta.
  - `alpha1`: A data frame of posterior samples for alpha1.
  - `alpha2`: A data frame of posterior samples for alpha2.
  - `delta1`: A data frame of posterior samples for delta1.
  - `delta2`: A data frame of posterior samples for delta2.
  - `rho`: A data frame of posterior samples for rho.
}
\description{
This function generates posterior samples for all parameters based on the dynamic probit unfolding model.
}
\examples{
\donttest{
# Long-running example
data(scotus.1937.2021)
hyperparams = list(alpha_mean = c(0, 0), alpha_scale = 5,
                   delta_mean = c(-2, 10), delta_scale = sqrt(10),
                   rho_mean = 0.9, rho_sigma = 0.04)
control = list(num_iter = 2, burn_in = 0, keep_iter = 1, flip_rate = 0.1, sd_prop_rho = 0.1)
sign_refs = list(pos_inds = c(39, 5), neg_inds = c(12, 29),
                 pos_year_inds = list(1:31, 1), neg_year_inds = list(1:29, 1:24))
scotus.pum = sample_pum_dynamic(mqVotes, mqTime, hyperparams, control, sign_refs,
                                verbose = FALSE, pre_run = NULL, appended = FALSE)
}
}
