% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.summary.lm.equation}
\alias{style.apa.summary.lm.equation}
\title{Formats the summary of a Linear Model Fit (regression equation)}
\usage{
style.apa.summary.lm.equation(x, respname = out.above(out.identifier("y"),
  out.operator("^")), coeff.name = names(x$coefficients[, 1]))
}
\arguments{
\item{x}{a list. First item must be the summary of a linear model fit from
\code{\link[stats]{lm}}. All other list items will be ignored.}

\item{respname}{a character. This argument specifies how the response is
called.}

\item{coeff.name}{a character. This argument specifies how the coefficients
are named.}
}
\value{
character vector with a formatted character vector.
}
\description{
This style functions takes the summary of a linear model fit from
\code{\link[stats]{lm}} and transforms it into a formatted character
vector. It prints the regression equation.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
pprint(summary(lm.D9),
       format = "summary.lm.equation")
}
\seealso{
\code{\link[stats]{lm}}

Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

