% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pmids_from_searches.R
\name{get_pmids_from_searches}
\alias{get_pmids_from_searches}
\title{Downloads PMID results for a column of Pubmed search queries in a
data frame}
\usage{
get_pmids_from_searches(df, column, api_key, quiet = FALSE)
}
\arguments{
\item{df}{A dataframe containing a column of Pubmed search
queries. This data frame cannot have columns with the following
names: \code{pubmed_search_success}, \code{pmids}.}

\item{column}{The name of the column containing Pubmed search
queries}

\item{api_key}{A valid Pubmed API key}

\item{quiet}{A boolean TRUE or FALSE. If TRUE, no progress messages
will be printed during download. FALSE by default, messages
printed for every version downloaded showing progress.}
}
\value{
A data frame containing the original columns as well as
three additional columns:

\if{html}{\out{<div class="sourceCode">}}\preformatted{The `pubmed_search_success` column is TRUE in the case that the
search rcesults were successfully obtained from Pubmed; FALSE
in the case that an error occurred in search (e.g. due to a
search query that is not well-formed).

The `n_results` column contains the number of research results
for the query provided.

The `pmids` column returns a JSON-encoded list of PMID's for
the search query provided.
}\if{html}{\out{</div>}}
}
\description{
Downloads PMID results for a column of Pubmed search queries in a
data frame
}
\examples{

\dontrun{
## Read in API key
ak <- readLines("api_key.txt")

## Example Pubmed searches, some valid, some not, some with more
## than 10k results
searches <- tribble(
  ~terms,
  "Carlisle B[Author]",
  "NCT00267865",
  "(Clinical Trial[Publication Type])",
  ""
)

## Download search results
results <- get_pmids_from_searches(searches, "terms", ak)
}
}
