% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url-manipulation.R
\name{add_parameter}
\alias{add_parameter}
\title{Suffix a parameter to a HTML request}
\usage{
add_parameter(
  request,
  parameter_name,
  parameter_value,
  .combine = "repeat_name"
)
}
\arguments{
\item{request}{Character. The base URL or request which will be suffixed with
the parameter.}

\item{parameter_name}{Character. Name of parameter to suffix.}

\item{parameter_value}{Character, or a value that can be coerced to a
character. The value of the parameter to suffix.}

\item{.combine}{How to combine parameters with multiple values. One
of "repeat_name", "with_commas", "with_hex_commas". See Details.}
}
\value{
Character. The request with suffixed parameters.
}
\description{
Parameters are suffixed to a URL, like so:
"request?para1=value1&para2=value2". The first parameter is suffixed with "?"
and all others after that "&". This function will determine the correct
suffix based on the presence of "&" in the request.
}
\details{
There is no standardised way to combine multiple values for a
parameter. You should see how your API expects multiple values to be provided
to the same parameter. This function allows for the following strategies. If
any other value is provided, then the values will be concatenated and
separated with the provided value.
\itemize{
\item "repeat_name" (default). The values of the parameter are repeated
with the parameter name. For example, \verb{("request", "para", c(1, 2))} will
return "request?para=1&para=2".
\item "with_commas". The values of the parameter are concatenated and
separated with commas. For example, \verb{("request", "para", c(1, 2))} will
return "request?para=1,2".
\item "with_commas". The values of the parameter are concatenated and
separated with the ASCII keycode in hexadecimal for a comma ("\%2C"). For
example, \verb{("request", "para", c(1, 2))} will return "request?para=1\%2C2".
}
}
\examples{
\dontrun{
ptvapi:::add_parameter("www.example.com", "animal", "crocodile")
ptvapi:::add_parameter(
  "www.example.com",
  "numbers",
  c(1, 2, 3),
  .combine = "repeat_names"
)}

}
\keyword{internal}
