% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alpha_moment}
\alias{alpha_moment}
\title{Estimating the Shape Parameter by Method of Moments}
\usage{
alpha_moment(dat)
}
\arguments{
\item{dat}{vector of observations}
}
\value{
A list of the following form:
\describe{
  \item{shape}{Estimate of the shape parameter of the data}
  \item{scale}{Estimate of the scale parameter of the data (which is taken
  to be the minimum of the data)}
}
}
\description{
This function uses the Method of Moments to estimate the shape parameter
of a given set of data. (Rytgaard 1990) The method of moments is only 
accurate if \eqn{\alpha} (\code{shape parameter}) is greater than or equal 
to 1 (Brazauskas and Serfling 2000). This function issues a warning if it 
detects that \eqn{\alpha} may be less than 1.
}
\examples{
x <- generate_pareto(10000, 5, 2)
alpha_moment(x)
}
\references{
Rytgaard M (1990). "Estimation In The Pareto Distribution." ASTIN
 Bulletin: The Journal Of The IAA, 20(2), 201-216.
 
 Brazauskas V, Serfling R (2000). "Robust and Efficient Estimation Of 
 The Tail Index Of A Single-Parameter Pareto Distribution." North 
 American Actuarial Journal, 4, 12-27.
}
