% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{env.Ztest}
\alias{env.Ztest}
\title{Preferred/Avoided Amino Acids Within an Environment}
\usage{
env.Ztest(pos, ctr, alpha = 0.05)
}
\arguments{
\item{pos}{a 21 x m matrix containing the absolute frequencies of 21 amino acids at the m positions, in the positive environments.}

\item{ctr}{a 21 x m matrix containing the absolute frequencies of 21 amino acids at the m positions, in the control environments.}

\item{alpha}{significance level.}
}
\value{
Returns a list with three elements: (1) a matrix with the values of the Z statistical. (2) A dataframe with information regarding amino acid overrepresented in the positive environments, and (3) a dataframe similar to the previous one, but for amino acids avoided from the positive environments.
}
\description{
Searches for amino acids either overrepresented or avoided at given positions within a sequence environment.
}
\details{
Please, note that in addition to the 20 proteinogenetic amino acid we are using the symbol X when the target (central) residue is closer to the N-terminal or C-terminal of the protein than the radius used.
}
\examples{
pos = env.matrices(hmeto$positive)[[2]][,-11]; ctr = env.matrices(hmeto$control)[[2]][,-11]
env.Ztest(pos, ctr, alpha = 0.0001)
}
\references{
Aledo et al. Sci Rep. 2015; 5: 16955. (PMID: 26597773)
}
\seealso{
env.extract(), env.matrices() and env.plot()
}
\author{
Juan Carlos Aledo
}
