% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa.R
\name{is.at}
\alias{is.at}
\title{Check Residue a Fixed Position}
\usage{
is.at(at, target, aa = 'M', uniprot = TRUE)
}
\arguments{
\item{at}{the position in the primary structure of the protein.}

\item{target}{a character string specifying the UniProt ID of the protein of interest or, alternatively, the sequence of that protein.}

\item{aa}{the amino acid of interest.}

\item{uniprot}{logical, if TRUE the argument 'target' should be an ID.}
}
\value{
Returns a boolean. Either the residue is present at that position or not.
}
\description{
Checks if a given amino acid is at a given position.
}
\details{
Please, note that when uniprot is set to FALSE, target can be the string returned by a suitable function, such as get.seq or other.
}
\examples{
is.at(28, 'P01009', 'Q')
is.at(at = 80, target = get.seq('P00004', 'metosite'), uniprot = FALSE)
}
\seealso{
aa.at(), renum.pdb(), renum.meto(), renum(), aa.comp()
}
\author{
Juan Carlos Aledo
}
