% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_dct_dir.R, R/load_dct_specs.R
\name{load_dct_dir}
\alias{load_dct_dir}
\alias{load_dct_specs}
\alias{print.dct_specs}
\alias{plot.dct_specs}
\title{Load DCT specifications from a file or multiple files}
\usage{
load_dct_dir(
  path,
  recursive = TRUE,
  extension = "rock|dct",
  regex,
  dctContainer = "dct",
  headingLevel = 2,
  delimiterRegEx = "^---$",
  ignoreOddDelimiters = FALSE,
  encoding = "UTF-8",
  silent = TRUE
)

load_dct_specs(
  text,
  file,
  delimiterRegEx = "^---$",
  dctContainer = "dct",
  headingLevel = 2,
  ignoreOddDelimiters = FALSE,
  encoding = "UTF-8",
  silent = TRUE
)

\method{print}{dct_specs}(x, ...)

\method{plot}{dct_specs}(x, ...)
}
\arguments{
\item{path}{The path containing the files to read.}

\item{recursive}{Whether to also process subdirectories (\code{TRUE})
or not (\code{FALSE}).}

\item{extension}{The extension of the files to read; files with other extensions will
be ignored. Multiple extensions can be separated by a pipe (\code{|}).}

\item{regex}{Instead of specifing an extension, it's also possible to specify a regular
expression; only files matching this regular expression are read. If specified, \code{regex}
takes precedece over \code{extension},}

\item{dctContainer}{The container of the DCT specifications in the YAML
fragments. Because only DCT specifications are read that are stored in
this container, the files can contain YAML fragments with other data, too,
without interfering with the parsing of the DCT specifications.}

\item{headingLevel}{The level of the Markdown headings that are produced.}

\item{delimiterRegEx}{The regular expression used to locate YAML
fragments}

\item{ignoreOddDelimiters}{Whether to throw an error (FALSE) or
delete the last delimiter (TRUE) if an odd number of delimiters is
encountered.}

\item{encoding}{The encoding to use when calling \code{\link[=readLines]{readLines()}}. Set to
NULL to let \code{\link[=readLines]{readLines()}} guess.}

\item{silent}{Whether to be silent (TRUE) or informative (FALSE).}

\item{text, file}{As \code{text} or \code{file}, you can specify a \code{file} to read with
encoding \code{encoding}, which will then be read using \code{\link[base:readLines]{base::readLines()}}. If the
argument is named \code{text}, whether it is the path to an existing file is checked
first, and if it is, that file is read. If the argument is named \code{file}, and it
does not point to an existing file, an error is produced (useful if calling
from other functions). A \code{text} should be a character vector where every
element is a line of the original source (like provided by \code{\link[base:readLines]{base::readLines()}});
although if a character vector of one element \emph{and} including at least one
newline character (\verb{\\\\n}) is provided as \code{text}, it is split at the newline
characters using \code{\link[base:strsplit]{base::strsplit()}}. Basically, this behavior means that the
first argument can be either a character vector or the path to a file; and if
you're specifying a file and you want to be certain that an error is thrown if
it doesn't exist, make sure to name it \code{file}.}

\item{x}{The parsed \code{parsed_dct} object.}

\item{...}{Any other arguments are passed to the print command.}
}
\value{
An object with the \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph stored
in \code{output$basic_graph}, a \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph with a summary
of which specifications are provided for each construct in
\code{output$completeness_graph} and the instructions in \code{output$instr}.
}
\description{
These function load DCT specifications from the YAML fragments
in one (\code{load_dct_specs}) or multiple files (\code{load_dct_dir}).
}
\details{
\code{load_dct_dir} simply identifies all files and then calls
\code{load_dct_specs} for each of them. \code{load_dct_specs} loads the
YAML fragments containing the DCT specifications using
\code{\link[yum:load_yaml_fragments]{yum::load_yaml_fragments()}} and then parses the DCT
specifications into a visual representation as a
\link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph and Markdown documents with
the instructions for creating measurement instruments or
manipulations, and for coding measurement instruments,
manipulations, or aspects of a construct.
}
\examples{
exampleSpec <-
  system.file("inst",
              "extdata",
              "example_dct_spec_1.dct",
              package="psyverse");
load_dct_specs(exampleSpec);

\dontrun{
psyverse::load_dct_dir(path="A:/some/path");
}

}
