\name{summary.lambda}
\alias{summary.lambda}
\alias{print.summary.lambda}

\title{ Summary Method for Objects of Class `lambda'}
\description{
Identical to \code{summary.glm} but with one line of additional output: the estimate of lambda from \code{glm.lambda}, obtained by profiling the deviance and estimating its minimum.}
\usage{
\method{summary}{lambda}(object, ...)
\method{print}{summary.lambda}(x, digits = max(3, getOption("digits") - 3), 
  symbolic.cor = x$symbolic.cor, 
  signif.stars = getOption("show.signif.stars"), ...) 
}

\arguments{
  \item{object}{ Fitted model object of class \dQuote{lambda} inheriting from \code{glm} and \code{lm}.  Typically the output of \code{glm.lambda}.}
  \item{x}{ an object of class \dQuote{summary.lambda}, usually a result of a call to \code{summary.lambda}.  }
  \item{digits}{ the number of significant digits to use when printing.}
  \item{symbolic.cor}{logical. If \code{TRUE}, print the correlations in a symbolic form (see \code{\link{symnum}}) rather than as numbers.}
  \item{signif.stars}{logical.  If \code{TRUE}, \dQuote{significance stars} are printed for each coefficient.}
  \item{\dots}{further arguments passed to or from other methods. }
}
\details{
 Provides a summary of the class \code{lambda} object generated by \code{glm.lambda}.
}
\value{
 Returns the same structure as \code{\link{summary.glm}} with an added component, \code{lambda}.  \eqn{1 - \lambda} is the estimated upper asymptote of the psychometric function.
}
\author{ Ken Knoblauch }

\seealso{ \code{\link{probit.lambda}},  \code{\link{glm.lambda}} }
\examples{

}
\keyword{ methods }
\keyword{ print }
