% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-classes.R, R/aaa-generics.R
\docType{class}
\name{Model-class}
\alias{Model-class}
\alias{ndocs,Model-method}
\alias{ndocs<-,Model-method}
\alias{nchain,Model-method}
\alias{nchain<-,Model-method}
\alias{mu0,Model-method}
\alias{mu0<-,Model-method}
\alias{sigma0,Model-method}
\alias{sigma0<-,Model-method}
\alias{eta_start,Model-method}
\alias{eta_start<-,Model-method}
\alias{eta,Model-method}
\alias{eta<-,Model-method}
\alias{loglike,Model-method}
\alias{loglike<-,Model-method}
\alias{logpost,Model-method}
\alias{logpost<-,Model-method}
\alias{waic,Model-method}
\alias{waic<-,Model-method}
\alias{se_waic,Model-method}
\alias{se_waic<-,Model-method}
\alias{p_eff,Model-method}
\alias{p_eff<-,Model-method}
\alias{lpd,Model-method}
\alias{lpd<-,Model-method}
\alias{extra,Model-method}
\alias{extra<-,Model-method}
\alias{Model}
\title{An S4 super class to represent a regression-like model}
\usage{
\S4method{ndocs}{Model}(x)

\S4method{ndocs}{Model}(x) <- value

\S4method{nchain}{Model}(x)

\S4method{nchain}{Model}(x) <- value

\S4method{mu0}{Model}(x)

\S4method{mu0}{Model}(x) <- value

\S4method{sigma0}{Model}(x)

\S4method{sigma0}{Model}(x) <- value

\S4method{eta_start}{Model}(x)

\S4method{eta_start}{Model}(x) <- value

\S4method{eta}{Model}(x)

\S4method{eta}{Model}(x) <- value

\S4method{loglike}{Model}(x)

\S4method{loglike}{Model}(x) <- value

\S4method{logpost}{Model}(x)

\S4method{logpost}{Model}(x) <- value

\S4method{waic}{Model}(x)

\S4method{waic}{Model}(x) <- value

\S4method{se_waic}{Model}(x)

\S4method{se_waic}{Model}(x) <- value

\S4method{p_eff}{Model}(x)

\S4method{p_eff}{Model}(x) <- value

\S4method{lpd}{Model}(x)

\S4method{lpd}{Model}(x) <- value

\S4method{extra}{Model}(x)

\S4method{extra}{Model}(x) <- value

Model(
  ndocs,
  nchain = 1,
  mu0 = NaN,
  sigma0 = NaN,
  eta_start = NaN,
  eta = NaN,
  loglike = NaN,
  logpost = NaN,
  waic = NaN,
  se_waic = NaN,
  p_eff = NaN,
  lpd = NaN
)
}
\arguments{
\item{x}{An \code{Model} object.}

\item{value}{A value to assign to a slot for \code{x}}

\item{ndocs}{The number of documents/observations.}

\item{nchain}{The number of iterations of the Gibbs sampler.}

\item{mu0}{A (p + 1) x 1 matrix of prior means for eta.}

\item{sigma0}{A (p + 1) x (p + 1) prior covariance matrix for eta.}

\item{eta_start}{A (p + 1) x 1 matrix of starting values for eta.}

\item{eta}{A nchain x (p + 1) matrix of draws of regression coefficients.}

\item{loglike}{A nchain x 1 vector of the log-likelihood (up to an additive
constant).}

\item{logpost}{A nchain x 1 vector of the log-posterior (up to an additive
constant).}

\item{waic}{WAIC (up to an additive constant) on the deviance scale.}

\item{se_waic}{Standard error of the WAIC.}

\item{p_eff}{The effective number of parameters.}

\item{lpd}{A nchain x ndocs matrix of predictive posterior likelihoods.}
}
\value{
A \linkS4class{Model} object.
}
\description{
An S4 super class to represent a regression-like model

Helper function (constructor) for \code{Model} class
}
\section{Slots}{

\describe{
\item{\code{ndocs}}{The number of documents/observations.}

\item{\code{nchain}}{The number of iterations of the Gibbs sampler.}

\item{\code{mu0}}{A (p + 1) x 1 matrix of prior means for eta.}

\item{\code{sigma0}}{A (p + 1) x (p + 1) prior covariance matrix for eta.}

\item{\code{eta_start}}{A (p + 1) x 1 matrix of starting values for eta.}

\item{\code{eta}}{A nchain x (p + 1) matrix of draws of regression coefficients.}

\item{\code{loglike}}{A nchain x 1 vector of the log-likelihood (up to an additive
constant).}

\item{\code{logpost}}{A nchain x 1 vector of the log-posterior (up to an additive
constant).}

\item{\code{waic}}{WAIC (up to an additive constant) on the deviance scale.}

\item{\code{se_waic}}{Standard error of the WAIC.}

\item{\code{p_eff}}{The effective number of parameters.}

\item{\code{lpd}}{A nchain x ndocs matrix of predictive posterior likelihoods.}

\item{\code{extra}}{A list of additional model fitting information. Contains
time_elapsed, start_time, end_time, corrected_label_switching, and call.}
}}

\examples{
m1 <- Model(ndocs = 1)
print(m1)

}
\keyword{classes}
