% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize.glm}
\alias{standardize.glm}
\title{Standardize Coefficients.}
\usage{
\method{standardize}{glm}(x, method = "agresti", ...)
}
\arguments{
\item{x}{A linear model.}

\item{method}{The standardization method. Can be "agresti".}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Compute standardized coefficients.
}
\examples{
\dontrun{
library(psycho)
fit <- glm(Sex ~ Adjusting, data=psycho::affective, family="binomial")
fit <- lme4::glmer(Sex ~ Adjusting + (1|Sex), data=psycho::affective, family="binomial")

standardize(fit)

}

}
\seealso{
https://think-lab.github.io/d/205/
}
\author{
Kamil Barton
}
