% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.stanreg.R
\name{get_std_posteriors}
\alias{get_std_posteriors}
\title{Compute standardized posteriors.}
\usage{
get_std_posteriors(fit, method = "posterior")
}
\arguments{
\item{fit}{A stanreg model.}

\item{method}{"posterior" (default, based on estimated SD) or "sample" (based on the sample SD).}
}
\description{
Compute standardized posteriors from which to get standardized coefficients.
}
\examples{
\dontrun{
library(psycho)
library(rstanarm)

data <- attitude
fit <- rstanarm::stan_glm(rating ~ advance + privileges, data=data)

posteriors <- get_std_posteriors(fit)

}

}
\author{
\href{https://github.com/jgabry}{Jonah Gabry}, \href{https://github.com/bgoodri}{bgoodri}
}
