% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{metabulate_rmd_helper}
\alias{metabulate_rmd_helper}
\title{Add metabulate equation commands and LaTeX dependencies}
\usage{
metabulate_rmd_helper(latex = TRUE, html = TRUE, word_proc = TRUE)
}
\arguments{
\item{latex}{Should required commands be included when converting to PDF, LaTeX, and related formats?}

\item{html}{Should required commands be included when converting to HTML and related formats?}

\item{word_proc}{Should required commands be included when converting to Word, ODT, and related formats?}
}
\value{
Requested commands are printed to the console.
}
\description{
\code{\link{metabulate}} requires several lines of code to correctly render meta-analysis results table column headings and footnotes. If \code{metabulate} is used to render files directly, these are added to the internal RMarkdown document. If you use \code{metabulate} output in a larger RMarkdown document, use this function to automatically add the necessary lines of code based on your chosen output format.
}
\section{PDF and LaTeX output}{

If \code{latex} is \code{TRUE} and you render to PDF, LaTeX, or other output
formats requiring LaTeX (e.g., \code{beamer_presentation}, see \code{\link[knitr:output_type]{knitr::is_latex_output}}),
a YAML metadata block with a \code{header-includes} argument calling the required
\code{unicode-math} LaTeX package is printed.

An RMarkdown file can only include one \code{header-includes} metadata entry. If
your document already has one, set \code{latex} to \code{FALSE} and manually add
add the \code{unicode-math} package to your LaTeX header instead.

(Note that \code{header-includes} is generally discouraged in favor of adding
an \code{include} argument to specific output formats, see
\url{http://rmarkdown.rstudio.com/pdf_document_format.html#includes}.)
}

\section{HTML output}{

If \code{html} is \code{TRUE} and you render to HTML (or related formats, see
\code{\link[knitr:output_type]{knitr::is_html_output}}, the following LaTeX
math commands are defined:
\itemize{
  \item{\code{symit}}{}
  \item{\code{symup}}{}
  \item{\code{symbfit}}{}
  \item{\code{symbfup}}{}
}

If you define your own LaTeX or MathJax macros for these commands, set
\code{html} to \code{FALSE}.
}

\section{Microsoft Office and LibreOffice output}{

If \code{word_proc} is \code{TRUE} and you render to Word or ODT (or related
formats such as PowerPoint), the following LaTeX math commands are defined:
\itemize{
  \item{\code{symit}}{}
  \item{\code{symup}}{}
  \item{\code{symbfit}}{}
  \item{\code{symbfup}}{}
}

If you define your own LaTeX, Office, or OpenDocument macros for these commands,
set \code{word_proc} to \code{FALSE}.
}

\examples{
## Include this line as 'asis' output in your RMarkdown document:
metabulate_rmd_helper()

## If you've already included \\usepackage{unicode-math} in your RMarkdown header
## for PDF (and related formats) header, set latex to FALSE:
metabulate_rmd_helper(latex = FALSE)
}
\seealso{
Other output functions: 
\code{\link{generate_bib}()},
\code{\link{metabulate}()}
}
\concept{output functions}
