% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_d.R
\name{correct_d_bias}
\alias{correct_d_bias}
\title{Correct for small-sample bias in Cohen's \emph{d} values}
\usage{
correct_d_bias(d, n)
}
\arguments{
\item{d}{Vector of Cohen's d values.}

\item{n}{Vector of sample sizes.}
}
\value{
Vector of d values corrected for small-sample bias.
}
\description{
Corrects a vector of Cohen's \emph{d} values for small-sample bias, as Cohen's \emph{d} has a slight positive bias.
}
\details{
The bias correction is estimated as:

\deqn{d_{c}=\frac{d_{obs}}{1+\frac{.75}{n-3}}}{d_c = d / (1 + .75 / (n - 3))}

where \eqn{d_{obs}}{d} is the observed effect size, \eqn{d_{c}}{d_c} is the corrected estimate of \emph{d}, and \emph{n} is the total sample size.
}
\examples{
correct_d_bias(d = .3, n = 30)
correct_d_bias(d = .3, n = 300)
correct_d_bias(d = .3, n = 3000)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: SAGE. \url{https://doi.org/10/b6mg}. pp. 293–295.
}
