% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ad.R
\name{create_ad_array}
\alias{create_ad_array}
\title{Create an array of all possible combinations of artifact values from 2-4 artifact distributions}
\usage{
create_ad_array(ad_list, name_vec = NULL)
}
\arguments{
\item{ad_list}{List of artifact distribution tables (i.e., objects produced by the create_ad function).}

\item{name_vec}{Optional vector of artifact names that correspond to the tables in ad_list; if NULL, artifact names are taken from the names of list objects in ad_list.}
}
\value{
Data frame of all possible combinations of artifact values with the weight associated with each combination of artifacts.
}
\description{
Creates a fully crossed multidimensional array of artifacts and weights (with 1 to 4 dimensions of artifact values) for use in interactive artifact-distribution meta-analyses.
}
\examples{
#create_ad_array(ad_list = list(.create_ad_int(art_vec = c(.8, .8, .9),
#                                         wt_vec = c(100, 200, 100), decimals = 2),
#                               .create_ad_int(art_vec = c(.8, .8, .9),
#                                         wt_vec = c(100, 200, 100), decimals = 2)),
#                name_vec = c("q_x", "q_y"))
#create_ad_array(ad_list = list(q_x = .create_ad_int(art_vec = c(.8, .8, .9),
#                                               wt_vec = c(100, 200, 100), decimals = 2),
#                               q_y = .create_ad_int(art_vec = c(.8, .8, .9),
#                                               wt_vec = c(100, 200, 100), decimals = 2)))

}
\keyword{internal}
