% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pssmooth.R
\name{summary.riskCurve}
\alias{summary.riskCurve}
\title{Summary of Point and Interval Estimation of a Marginal Causal Effect Predictiveness Curve}
\usage{
\method{summary}{riskCurve}(object, boot = NULL, contrast = c("te", "rr",
  "logrr", "rd"), confLevel = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{riskCurve}, typically returned by \code{\link{riskCurve}}}

\item{boot}{an object returned by \code{\link{bootRiskCurve}}. If \code{NULL} (default), only point estimates are reported.}

\item{contrast}{a character string specifying the mCEP curve. It must be one of \code{te} (treatment efficacy), \code{rr} (relative risk), \code{logrr} (log relative risk), and \code{rd} (risk
difference [placebo minus treatment]).}

\item{confLevel}{the confidence level of pointwise and simultaneous confidence intervals}

\item{\dots}{for other methods}
}
\value{
A data frame containing point and possibly interval estimates of the specified mCEP curve.
}
\description{
Summarizes point estimates and pointwise and simultaneous Wald-type bootstrap confidence intervals for a specified marginal causal effect predictiveness (mCEP) curve (see,
e.g., Juraska, Huang, and Gilbert (2018) for the definition).
}
\examples{
n <- 500
Z <- rep(0:1, each=n/2)
S <- MASS::mvrnorm(n, mu=c(2,2,3), Sigma=matrix(c(1,0.9,0.7,0.9,1,0.7,0.7,0.7,1), nrow=3))
p <- pnorm(drop(cbind(1,Z,(1-Z)*S[,2],Z*S[,3]) \%*\% c(-1.2,0.2,-0.02,-0.2)))
Y <- sapply(p, function(risk){ rbinom(1,1,risk) })
# delete S(1) in placebo recipients
S[Z==0,3] <- NA
# delete S(0) in treatment recipients
S[Z==1,2] <- NA
# generate the indicator of being sampled into the phase 2 subset
phase2 <- rbinom(n,1,0.4)
# delete Sb, S(0) and S(1) in controls not included in the phase 2 subset
S[Y==0 & phase2==0,] <- c(NA,NA,NA)
# delete Sb in cases not included in the phase 2 subset
S[Y==1 & phase2==0,1] <- NA
data <- data.frame(Z,S[,1],ifelse(Z==0,S[,2],S[,3]),Y)
colnames(data) <- c("Z","Sb","S","Y")
qS <- quantile(data$S, probs=c(0.05,0.95), na.rm=TRUE)
grid <- seq(qS[1], qS[2], length.out=2)

out <- riskCurve(formula=Y ~ S, bsm="Sb", tx="Z", data=data, biomarkerGrid=grid)
boot <- bootRiskCurve(formula=Y ~ S, bsm="Sb", tx="Z", data=data,
                      biomarkerGrid=grid, iter=2, seed=10)
summary(out, boot, contrast="te")

}
\references{
Juraska, M., Huang, Y., and Gilbert, P. B., Inference on treatment effect modification by biomarker response in a three-phase sampling design. Under review.
}
\seealso{
\code{\link{riskCurve}} and \code{\link{bootRiskCurve}}
}
