% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_balance.R
\name{get_distance}
\alias{get_distance}
\title{Distance between two distributions}
\usage{
get_distance(cov0, cov1, metric = c("ovl", "ksd", "std", "abd", "ley", "mhb"))
}
\arguments{
\item{cov0}{Vector (or matrix for \code{mhb}) of samples from the first
distribution}

\item{cov1}{Vector (or matrix for \code{mhb}) of samples from the second
distribution}

\item{metric}{Metrics of distances with options
\describe{ \item{ovl}{Overlapping area}
    \item{ksd}{Kullback-Leibler distance} \item{std}{Standardized difference
    in mean} \item{abb}{Absolute difference in mean} \item{ley}{Levy
    distance} \item{mhb}{Mahalanobis distance}
}}
}
\value{
A real value of the distance
}
\description{
Get balance by different metrics
}
\examples{

x <- rnorm(100,  mean = 0, sd = 1)
y <- rnorm(1000, mean = 1, sd = 2)
get_distance(x, y, "ovl")
get_distance(x, y, "abd")

}
