% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{glmImp}
\alias{glmImp}
\title{Importace Measure for Generalized Linear Models}
\usage{
glmImp(obj, varname, data, level = 0.95, ci_method = c("perc", "norm"), ...)
}
\arguments{
\item{obj}{Model object, must be able to use \code{predict(obj, type="terms")}.}

\item{varname}{Character string giving the name of the variable whose importance
will be calculated.}

\item{data}{A data frame used to estiamte the model.}

\item{level}{Confidence level used for the confidence interval.}

\item{ci_method}{Character string giving the method for calculating the
confidence interval - normal or percentile.}

\item{...}{Other arguments being passed down to `avg_predictions()` from the \CRANpkg{marginaleffects} package.}
}
\value{
A data frame of importance measures with optimal bootstrapped confidence intervals.
}
\description{
Calculates importance along the lines of Greenwell et al (2018)
using partial dependence plots.
}
\examples{
\donttest{ 
data(gss)
mod <- glm(childs ~ sei10 + sex + educ + age, 
            data=gss, family=poisson)
g_imp1 <- glmImp(mod, "age", gss)
}
}
\references{
Greenwell, Brandon M., Bradley C. Boehmke and Andrew J. McCarthy.  (2018). “A Simple and Effective Model-Based Variable Importance Measure.”  arXiv1805.04755 [stat.ML]
}
