% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltablesurv.R
\name{constrain_survprob}
\alias{constrain_survprob}
\title{Constrain survival probabilities according to hazards in a lifetable
Recalculated constrained survival probabilities (by week) as the lower of the original unadjusted survival probability and the survival implied by the given lifetable (assumed indexed as years).}
\usage{
constrain_survprob(
  survprob1,
  survprob2 = NA,
  lifetable = NA,
  timevec = 0:(length(survprob1) - 1)
)
}
\arguments{
\item{survprob1}{(Unconstrained) survival probability value or vector}

\item{survprob2}{Optional survival probability value or vector to constrain on (default = NA)}

\item{lifetable}{Lifetable (default = NA)}

\item{timevec}{Vector of times corresponding with survival probabilities above}
}
\value{
Vector of constrained survival probabilities
}
\description{
Constrain survival probabilities according to hazards in a lifetable
Recalculated constrained survival probabilities (by week) as the lower of the original unadjusted survival probability and the survival implied by the given lifetable (assumed indexed as years).
}
\examples{
ltable <- tibble::tibble(lttime=0:20, lx=c(1,0.08,0.05,0.03,0.01,rep(0,16)))
survprob <- c(1,0.5,0.4,0.2,0)
constrain_survprob(survprob, lifetable=ltable)
timevec <- 100*(0:4)
constrain_survprob(survprob, lifetable=ltable, timevec=timevec)
survprob2 <- c(1,0.45,0.35,0.15,0)
constrain_survprob(survprob, survprob2)
}
