% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_cont_normal.R
\name{outcome_cont_normal}
\alias{outcome_cont_normal}
\title{Normal Outcome Distribution}
\usage{
outcome_cont_normal(
  continuous_var,
  baseline_prior,
  std_dev_prior,
  weight_var = ""
)
}
\arguments{
\item{continuous_var}{character. Name of continuous outcome variable in the
model matrix}

\item{baseline_prior}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for the baseline outcome.
See \code{Details} for more information.}

\item{std_dev_prior}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for the standard deviation of the outcome distribution (i.e. "sigma").}

\item{weight_var}{character. Optional name of variable in model matrix for weighting the log likelihood.}
}
\value{
Object of class \code{\link[=OutcomeContinuousNormal-class]{OutcomeContinuousNormal}}.
}
\description{
Normal Outcome Distribution
}
\details{
\subsection{Baseline Prior}{

The \code{baseline_prior} argument specifies the prior distribution for the
intercept of the linear model. The interpretation of the \code{baseline_prior} differs
slightly between borrowing methods selected.
\itemize{
\item \emph{Dynamic borrowing using \code{borrowing_hierarchical_commensurate()}}: the \code{baseline_prior} for Bayesian Dynamic Borrowing
refers to the intercept of the external control arm.
\item \emph{Full borrowing} or \emph{No borrowing} using \code{borrowing_full()} or \code{borrowing_none()}: the \code{baseline_prior} for
these borrowing methods refers to the intercept for the
internal control arm.
}
}
}
\examples{
norm <- outcome_cont_normal(
  continuous_var = "tumor_size",
  baseline_prior = prior_normal(0, 100),
  std_dev_prior = prior_half_cauchy(1, 5)
)
}
\seealso{
Other outcome models: 
\code{\link{outcome_bin_logistic}()},
\code{\link{outcome_surv_exponential}()},
\code{\link{outcome_surv_weibull_ph}()}
}
\concept{outcome models}
