% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_time.R
\name{set_event}
\alias{set_event}
\title{Set up time-to-events}
\usage{
set_event(event, lambdaC, beta, shape, t_itv, change, keep)
}
\arguments{
\item{event}{Distribution of time-to-events: \code{event = "pwexp"} for piece-wise exponential distribution. \code{event = "weibull"} for weibull distribution}

\item{lambdaC}{Baseline hazard rate of internal control arm. Specify a vector for piece-wise hazard with duration specified in \code{t_itv} if \code{event = "pwexp"}}

\item{beta}{covariates' coefficients. \code{NULL} if no covariates are found in \code{ssObj}}

\item{shape}{shape of weibull distribution if \code{event = "weibull"}. \code{NULL} if \code{event = "pwexp"}}

\item{t_itv}{a vector indicating interval lengths where the exponential rates provided in \code{lambdaC} apply. Note that the length of \code{t_itv} is at least 1 less than that of \code{lambdaC} and that the final value rate in \code{lambdaC} applies after time \code{sum(t_itv)}. \code{NULL} if \code{event = "weibull"}}

\item{change}{operations applied to covariates for simulating time-to-events}

\item{keep}{original covariates to keep when simulate time-to-events}
}
\value{
a \code{.eventClass} class containing time-to-events information

a \code{matrix} containing simulated time-to-events information
}
\description{
Set up time-to-events
}
\examples{
# time-to-event follows a weibull distribution
set_event(event = "weibull", shape = 0.9, lambdaC = 0.0135)

# time-to-event follows a piece-wise exponential distribution
set_event(event = "pwexp", t_itv = 1, lambdaC = c(0.1, 0.02))


}
\keyword{constructor}
