% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cov.R
\name{set_cov}
\alias{set_cov}
\title{Set up covariates}
\usage{
set_cov(n_cat, n_cont, mu_int, mu_ext, var, cov, prob_int, prob_ext)
}
\arguments{
\item{n_cat}{Number of binary variable}

\item{n_cont}{Number of continuous variable}

\item{mu_int}{Mean of covariates in the internal trial. All the covariates are simulated from a multivariate normal distribution. If left \code{NULL}, it uses default value 0 for all covariates. If provided one value, this value is used for all covariates}

\item{mu_ext}{Mean of covariates in the external trial. If left \code{NULL}, it uses the same mean as mu_int}

\item{var}{Variance of covariates. If left \code{NULL}, it uses default value 0 for all covariates. If provided one value, it uses this value for all covariates}

\item{cov}{Covariance between each pair of covariates. Covariance needs to be provided in a certain order and users are encouraged to read the example provided in the vignette. If left \code{NULL}, it uses default value 0 for all covariates. If provided one value, it uses this value for every pair of covariates}

\item{prob_int}{Probability of binary covaraite equaling 1 in the internal trial. If left \code{NULL}, it uses default value 0.5 for all covariates. If provided one value, it uses this value for all covariates}

\item{prob_ext}{Probability of binary covaraite equaling 1 in the external trial. If left \code{NULL}, it uses the same probability as prob_int}
}
\value{
A \code{.covClass} class containing covariate information
}
\description{
This function saves the mean, variance and covariance among covariates. For technical details, see the vignette:
}
\keyword{constructor}
