% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_uids}
\alias{ps_uids}
\alias{ps_gids}
\title{User ids and group ids of the process}
\usage{
ps_uids(p)

ps_gids(p)
}
\arguments{
\item{p}{Process handle.}
}
\value{
Named integer vector of length 3, with names: \code{real},
\code{effective} and \code{saved}.
}
\description{
User ids and group ids of the process. Both return integer vectors with
names: \code{real}, \code{effective} and \code{saved}.
}
\details{
Both work for zombie processes.

They are not implemented on Windows, they throw a \code{not_implemented}
error.
}
\seealso{
\code{\link[=ps_username]{ps_username()}} returns a user \emph{name} and works on all
platforms.

Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_is_running}},
  \code{\link{ps_kill}}, \code{\link{ps_memory_info}},
  \code{\link{ps_name}}, \code{\link{ps_num_threads}},
  \code{\link{ps_pid}}, \code{\link{ps_ppid}},
  \code{\link{ps_resume}}, \code{\link{ps_send_signal}},
  \code{\link{ps_status}}, \code{\link{ps_suspend}},
  \code{\link{ps_terminal}}, \code{\link{ps_terminate}},
  \code{\link{ps_username}}

Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_is_running}},
  \code{\link{ps_kill}}, \code{\link{ps_memory_info}},
  \code{\link{ps_name}}, \code{\link{ps_num_threads}},
  \code{\link{ps_pid}}, \code{\link{ps_ppid}},
  \code{\link{ps_resume}}, \code{\link{ps_send_signal}},
  \code{\link{ps_status}}, \code{\link{ps_suspend}},
  \code{\link{ps_terminal}}, \code{\link{ps_terminate}},
  \code{\link{ps_username}}
}
\section{Examples}{
\Sexpr[stage=install,strip.white=FALSE,results=rd]{
ps:::decorate_examples(os = "POSIX",  '
p <- ps_handle()
p
ps_uids(p)
ps_gids(p)
')}
}
