% Generated by roxygen2 (4.0.1): do not edit by hand
\name{find_funs}
\alias{find_funs}
\alias{fun_args}
\alias{fun_body}
\alias{fun_calls}
\title{Find functions matching criteria.}
\usage{
find_funs(env = parent.frame(), extract, pattern, ...)

fun_calls(f)

fun_args(f)

fun_body(f)
}
\arguments{
\item{env}{environment in which to search for functions}

\item{extract}{component of function to extract. Should be a function that
takes a function as input as returns a character vector as output,
like \code{fun_calls} or \code{fun_args}.}

\item{pattern}{\pkg{stringr} regular expression to results of \code{extract}
function.}

\item{...}{other arguments passed on to \code{\link{grepl}}}

\item{f}{function to extract information from}
}
\description{
This is a flexible function that matches function component against
a regular expression, returning the name of the function if there are any
matches. \code{fun_args} and \code{fun_calls} are helper functions that
make it possible to search for functions with specified argument names, or
which call certain functions.
}
\examples{
find_funs("package:base", fun_calls, "match.fun", fixed = TRUE)
find_funs("package:stats", fun_args, "^[A-Z]+$")

fun_calls(match.call)
fun_calls(write.csv)

fun_body(write.csv)
find_funs("package:utils", fun_body, "write", fixed = TRUE)
}

