% Generated by roxygen2 (4.0.1): do not edit by hand
\name{call_tree}
\alias{ast}
\alias{call_tree}
\title{Display a call (or expression) as a tree.}
\usage{
call_tree(x, width = getOption("width"))

ast(x)
}
\arguments{
\item{x}{quoted call, list of calls, or expression to display}

\item{width}{displays width, defaults to current width as reported by
\code{getOption("width")}}
}
\description{
\code{call_tree} takes a quoted expression. \code{ast} does the quoting
for you.
}
\examples{
call_tree(quote(f(x, 1, g(), h(i()))))
call_tree(quote(if (TRUE) 3 else 4))
call_tree(expression(1, 2, 3))

ast(f(x, 1, g(), h(i())))
ast(if (TRUE) 3 else 4)
ast(function(a = 1, b = 2) {a + b})
ast(f()()())
}

