% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.counts}
\alias{read.counts}
\title{Read a .csv file with point-counting data}
\usage{
read.counts(fname, method = "chisq", colmap = "rainbow", ...)
}
\arguments{
\item{fname}{a string with the path to the .csv file}

\item{method}{either "chisq" (for the chi-square distance) or
"bray" (for the Bray-Curtis distance)}

\item{colmap}{an optional string with the name of one of R's
built-in colour palettes (e.g., heat.colors, terrain.colors,
topo.colors, cm.colors), which are to be used for plotting the
data.}

\item{...}{optional arguments to the built-in \code{read.csv}
function}
}
\value{
an object of class \code{counts}, i.e. a list with the
    following items:

\code{x}: a data frame with the samples as rows and the categories
as columns

\code{colmap}: the colour map provided by the input argument
}
\description{
Reads a data table containing point-counting data
(e.g. petrographic, heavy mineral, palaeontological or
palynological data)
}
\examples{
    fname <- system.file("HM.csv",package="provenance")
    Major <- read.counts(fname)
    #plot(PCA(HM))
}
