% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary.R
\name{text.ternary}
\alias{text.ternary}
\title{Ternary text plotting}
\usage{
\method{text}{ternary}(x, labels = 1:nrow(x$x), ...)
}
\arguments{
\item{x}{an object of class \code{ternary}, or a three-column data
frame or matrix}

\item{labels}{a character vector or expression specifying the text
to be written}

\item{...}{optional arguments to the generic \code{text} function}
}
\description{
Add text an existing ternary diagram
}
\examples{
data(Namib)
tern <- ternary(Namib$Major,'CaO','Na2O','K2O')
plot(tern,pch=21,bg='red',labels=NULL)
# add the geometric mean composition as a text label:
gmean <- ternary(exp(colMeans(log(tern$x))))
text(gmean,labels='geometric mean')
}
