% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.MDS}
\alias{plot.MDS}
\title{Plot an MDS configuration}
\usage{
\method{plot}{MDS}(x, nnlines = FALSE, pch = NA, pos = NULL, cex = 1,
  col = "black", bg = "white", oma = rep(1, 4), mar = rep(2, 4),
  mgp = c(2, 1, 0), xpd = NA, ...)
}
\arguments{
\item{x}{an object of class \code{MDS}}

\item{nnlines}{if TRUE, draws nearest neighbour lines}

\item{pch}{plot character (see ?plot for details). May be a vector.}

\item{pos}{position of the sample labels relative to the plot
symbols if pch != NA}

\item{cex}{relative size of plot symbols (see ?par for details)}

\item{col}{plot colour (may be a vector)}

\item{bg}{background colour (may be a vector)}

\item{oma}{A vector of the form \code{c(bottom, left, top, right)}
giving the size of the outer margins in lines of text.}

\item{mar}{A numerical vector of the form \code{c(bottom, left,
top, right)} that gives the number of lines of margin to be
specified on the four sides of the plot.}

\item{mgp}{The margin line (in \code{mex} units) for the axis
title, axis labels and axis line. See \code{?par} for further
details.}

\item{xpd}{A logical value or \code{NA}.  See \code{?par} for
further details.}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plots the coordinates of a multidimensional scaling analysis as an
X-Y scatter plot or 'map' and, if x$classical = FALSE, a Shepard
plot.
}
\examples{
data(Namib)
mds <- MDS(Namib$DZ)
coast <- c('N1','N2','N3','N10','N11','N12','T8','T13')
snames <- names(Namib$DZ)
bgcol <- rep('yellow',length(snames))
bgcol[which(snames \%in\% coast)] <- 'red'
plot(mds,pch=21,bg=bgcol)
}
\seealso{
MDS
}

