% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{getMDS}
\alias{getMDS}
\alias{getMDS.DZdata}
\alias{getMDS.HMdata}
\alias{getMDS.dist}
\title{Multidimensional Scaling}
\usage{
getMDS(x, ...)

\method{getMDS}{HMdata}(x, classical = FALSE, ...)

\method{getMDS}{DZdata}(x, classical = FALSE, ...)

\method{getMDS}{dist}(x, classical = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{DZdata}, \code{HMdata} or \code{dist}}

\item{...}{optional arguments to be passed onto \code{cmdscale} or
\code{isoMDS}}

\item{classical}{boolean flag indicating whether classical (TRUE)
or nonmetric (FALSE) MDS should be used}
}
\value{
an object of class \code{MDS}, i.e. a list containing the
following items:

\code{points}: a two column vector of the fitted configuration

\code{classical}: a boolean flag indicating whether the MDS
configuration was obtained by classical (\code{TRUE}) or nonmetric
(\code{FALSE}) MDS.

\code{diss}: the dissimilarity matrix used for the MDS analysis

\code{stress}: (only if \code{classical=TRUE}) the final stress
achieved (in percent)
}
\description{
Performs classical or nonmetric Multidimensional Scaling analysis
}
\examples{
fname <- system.file("Major.csv",package="provenance")
Major <- read.HMdata(fname)
plot(getMDS(Major,classical=TRUE))
}

