/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.fetch.ui;

import com.qarks.util.fetch.logic.DynamicDataSet;
import com.qarks.util.fetch.logic.DynamicTableDataProvider;
import com.qarks.util.fetch.ui.DynamicTable;
import com.qarks.util.ui.sort.SortableColumn;
import java.awt.GridLayout;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.util.Date;
import java.util.Random;
import javax.swing.JPanel;

public class DynamicTableTest
extends JPanel {
    private DynamicTable table;

    public DynamicTableTest() {
        final DateFormat dateFormat = DateFormat.getDateTimeInstance();
        this.setLayout(new GridLayout(1, 1));
        TestDataProvider testDataProvider = new TestDataProvider();
        this.table = new DynamicTable(testDataProvider);
        this.add(this.table);
        this.table.addColumn("name", new SortableColumn("Name"){

            @Override
            public Object getSubValue(Object object) {
                String string = null;
                if (object instanceof TestData) {
                    string = ((TestData)object).getName();
                }
                return string;
            }

            @Override
            public String getSubValueAsString(Object object) {
                return (String)this.getSubValue(object);
            }
        });
        this.table.addColumn("date", new SortableColumn("Date"){

            @Override
            public Object getSubValue(Object object) {
                Date date = null;
                if (object instanceof TestData) {
                    date = ((TestData)object).getWhen();
                }
                return date;
            }

            @Override
            public String getSubValueAsString(Object object) {
                Date date = (Date)this.getSubValue(object);
                String string = date != null ? dateFormat.format(date) : "";
                return string;
            }
        });
        this.table.addColumn("value", new SortableColumn("Value"){

            @Override
            public Object getSubValue(Object object) {
                Integer n = null;
                if (object instanceof TestData) {
                    int n2 = ((TestData)object).getValue();
                    n = new Integer(n2);
                }
                return n;
            }

            @Override
            public String getSubValueAsString(Object object) {
                Integer n = (Integer)this.getSubValue(object);
                String string = n != null ? n.toString() : "";
                return string;
            }
        });
    }

    public class TestDataProvider
    implements DynamicTableDataProvider {
        private TestData[] data = new TestData[100];
        private TestData[] sortedData;
        private String currentCriteria = "";
        private boolean currentAscending = true;

        public TestDataProvider() {
            Random random = new Random();
            Date date = new Date();
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = new TestData("value_" + i, new Date(date.getTime() - (long)(i * 10000)), random.nextInt());
            }
        }

        public int fetchDataCount(Object object) {
            return this.data.length;
        }

        @Override
        public DynamicDataSet fetchData(Object object, String string, boolean bl, int n, int n2) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.currentCriteria.equals(string) || this.currentAscending != bl) {
                if (string != null) {
                    this.sortedData = this.sort(this.data, string, bl);
                    if (string != null) {
                        this.currentCriteria = string;
                        this.currentAscending = bl;
                    }
                } else {
                    this.sortedData = this.data;
                }
            }
            int n3 = Math.min(this.data.length - n, n2);
            Object[] objectArray = new TestData[n3];
            for (int i = 0; i < objectArray.length; ++i) {
                int n4 = i + n;
                if (n4 < 0 || n4 >= this.sortedData.length) continue;
                objectArray[i] = this.sortedData[n4];
            }
            DynamicDataSet dynamicDataSet = new DynamicDataSet(objectArray, n, n + n2 >= this.data.length);
            return dynamicDataSet;
        }

        public TestData[] sort(TestData[] testDataArray, String string, boolean bl) {
            if (testDataArray == null) {
                return null;
            }
            Class<?> clazz = testDataArray.getClass().getComponentType();
            TestData[] testDataArray2 = (TestData[])Array.newInstance(clazz, testDataArray.length);
            for (int i = 0; i < testDataArray2.length; ++i) {
                testDataArray2[i] = testDataArray[i];
            }
            if (testDataArray.length > 0) {
                this.shuttlesort(testDataArray, testDataArray2, 0, testDataArray.length, bl, string);
            }
            return testDataArray2;
        }

        private void shuttlesort(TestData[] testDataArray, TestData[] testDataArray2, int n, int n2, boolean bl, String string) {
            if (n2 - n < 2) {
                return;
            }
            int n3 = (n + n2) / 2;
            this.shuttlesort(testDataArray2, testDataArray, n, n3, bl, string);
            this.shuttlesort(testDataArray2, testDataArray, n3, n2, bl, string);
            int n4 = n;
            int n5 = n3;
            if (n2 - n >= 4 && this.compare(testDataArray[n3 - 1], testDataArray[n3], bl, string) <= 0) {
                for (int i = n; i < n2; ++i) {
                    testDataArray2[i] = testDataArray[i];
                }
                return;
            }
            for (int i = n; i < n2; ++i) {
                testDataArray2[i] = n5 >= n2 || n4 < n3 && this.compare(testDataArray[n4], testDataArray[n5], bl, string) <= 0 ? testDataArray[n4++] : testDataArray[n5++];
            }
        }

        private int compare(TestData testData, TestData testData2, boolean bl, String string) {
            int n = 0;
            if (testData != null && testData2 != null) {
                if ("name".equals(string)) {
                    n = testData.getName().compareTo(testData2.getName());
                } else if ("date".equals(string)) {
                    long l;
                    long l2 = testData.getWhen().getTime();
                    if (l2 < (l = testData2.getWhen().getTime())) {
                        n = -1;
                    } else if (l2 > l) {
                        n = 1;
                    }
                } else if ("value".equals(string)) {
                    int n2;
                    int n3 = testData.getValue();
                    if (n3 < (n2 = testData2.getValue())) {
                        n = -1;
                    } else if (n3 > n2) {
                        n = 1;
                    }
                }
                if (!bl) {
                    n = -n;
                }
            }
            return n;
        }
    }

    public class TestData {
        private String name;
        private Date when;
        private int value;

        public TestData(String string, Date date, int n) {
            this.name = string;
            this.when = date;
            this.value = n;
        }

        public String getName() {
            return this.name;
        }

        public Date getWhen() {
            return this.when;
        }

        public int getValue() {
            return this.value;
        }
    }
}

