/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import com.qarks.util.HexConverter;
import com.qarks.util.http.HttpCertificateGranter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TrustManagerAppender
implements X509TrustManager {
    private HttpCertificateGranter granter;
    private X509TrustManager defaultTrustManager;
    private SSLContext sslContext;
    private File keystoreFile;
    private KeyStore keystore;
    private Hashtable<String, X509Certificate> granted;
    private Hashtable<String, X509Certificate> rejected;

    public TrustManagerAppender(HttpCertificateGranter httpCertificateGranter) throws Exception {
        this.granter = httpCertificateGranter;
        this.granted = new Hashtable();
        this.rejected = new Hashtable();
        char c = File.separatorChar;
        String string = "changeit";
        File file = new File(System.getProperty("user.home") + c + ".security" + c);
        this.keystoreFile = new File(file, "cacerts");
        System.out.println("Loading KeyStore " + this.keystoreFile + "...");
        FileInputStream fileInputStream = new FileInputStream(this.keystoreFile);
        this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keystore.load(fileInputStream, string.toCharArray());
        ((InputStream)fileInputStream).close();
        this.sslContext = SSLContext.getInstance("SSL");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.keystore);
        this.defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        this.sslContext.init(null, new TrustManager[]{this}, null);
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    private void trustCertificate(X509Certificate[] x509CertificateArray, String string) throws Exception {
        X509Certificate x509Certificate = x509CertificateArray[0];
        String string2 = ((Object)x509Certificate.getIssuerDN()).toString();
        this.keystore.setCertificateEntry(string2, x509Certificate);
        FileOutputStream fileOutputStream = new FileOutputStream(this.keystoreFile);
        this.keystore.store(fileOutputStream, "changeit".toCharArray());
        ((OutputStream)fileOutputStream).close();
        System.out.println();
        System.out.println(x509Certificate);
        System.out.println();
        System.out.println("Added certificate to keystore '" + this.keystoreFile.getName() + "' using alias '" + string2 + "'");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        block10: {
            try {
                if (this.wasGranted(x509CertificateArray[0])) break block10;
                if (this.wasRejected(x509CertificateArray[0])) {
                    throw new CertificateException("certificate already rejected");
                }
                if (this.defaultTrustManager != null) {
                    this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
                    break block10;
                }
                throw new CertificateException("no default manager");
            }
            catch (CertificateException certificateException) {
                System.err.println("certificate rejected by default trust manager: " + certificateException.getMessage());
                if (this.granter != null) {
                    HttpCertificateGranter.GrantType grantType = this.granter.checkServerTrusted(x509CertificateArray, string);
                    if (grantType == HttpCertificateGranter.GrantType.NO) {
                        this.reject(x509CertificateArray[0]);
                        throw certificateException;
                    }
                    if (grantType == HttpCertificateGranter.GrantType.YES) {
                        this.grant(x509CertificateArray[0]);
                    }
                    if (grantType != HttpCertificateGranter.GrantType.STORE) break block10;
                    try {
                        this.grant(x509CertificateArray[0]);
                        this.trustCertificate(x509CertificateArray, string);
                    }
                    catch (Exception exception) {
                        if (exception instanceof CertificateException) {
                            throw (CertificateException)exception;
                        }
                        throw new CertificateException(exception);
                    }
                }
                throw certificateException;
            }
        }
    }

    private boolean wasGranted(X509Certificate x509Certificate) {
        boolean bl = false;
        try {
            byte[] byArray = x509Certificate.getSignature();
            if (this.granted.get(HexConverter.toHexString(byArray)) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private void grant(X509Certificate x509Certificate) {
        try {
            byte[] byArray = x509Certificate.getSignature();
            this.granted.put(HexConverter.toHexString(byArray), x509Certificate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean wasRejected(X509Certificate x509Certificate) {
        boolean bl = false;
        try {
            byte[] byArray = x509Certificate.getSignature();
            if (this.rejected.get(HexConverter.toHexString(byArray)) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private void reject(X509Certificate x509Certificate) {
        try {
            byte[] byArray = x509Certificate.getSignature();
            this.rejected.put(HexConverter.toHexString(byArray), x509Certificate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        throw new UnsupportedOperationException();
    }
}

