/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.files.FileLaunchHandler;
import java.awt.Desktop;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import javax.swing.filechooser.FileSystemView;

public class FileLauncher {
    private static FileLauncher sInstance = null;
    private Hashtable mTable = new Hashtable();

    private FileLauncher() {
    }

    public void addFileLaunchHandler(FileLaunchHandler fileLaunchHandler) {
        String[] stringArray = fileLaunchHandler.getSupportedExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mTable.put(stringArray[i].toLowerCase(), fileLaunchHandler);
        }
    }

    public void removeFileLaunchHandler(FileLaunchHandler fileLaunchHandler) {
        String[] stringArray = fileLaunchHandler.getSupportedExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mTable.remove(stringArray[i]);
        }
    }

    public static FileLauncher getInstance() {
        if (sInstance == null) {
            sInstance = new FileLauncher();
        }
        return sInstance;
    }

    public void launchFile(File file, Window window) throws FileNotFoundException {
        String string;
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        String string3 = "";
        FileLaunchHandler fileLaunchHandler = null;
        if (n > -1 && (string = this.mTable.get(string3 = string2.substring(n + 1).toLowerCase())) instanceof FileLaunchHandler) {
            fileLaunchHandler = (FileLaunchHandler)((Object)string);
        }
        if (fileLaunchHandler != null) {
            fileLaunchHandler.launchFile(file);
        } else {
            string = FileSystemView.getFileSystemView().getSystemTypeDescription(file);
            if (string != null && string.length() > 0) {
                this.systemLaunchFile(file);
            }
        }
    }

    public static void systemLaunchLine(String string) {
        try {
            Desktop.getDesktop().open(new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void systemLaunchFile(File file) {
        FileLauncher.systemLaunchLine(file.getAbsolutePath());
    }
}

